

				/*this code converts the spss data set to SAS*/

libname libref spss 'c:\sascodeforbook\sasdatasets\newscore.por';
data tryone; set libref._first_;

Proc contents; run;

libname q 'c:\sascodeforbook\sasdatasets';

data q.chap14tab4; set tryone;
proc contents; run;

				/* This completes the data set creation*/


libname q 'c:\SAScodeforbook\SASDataSets';

Data panela; set q.chap14tab4; 
if conftype =0;

	/*Estimates for Panel a of Table 14.4*/

Title 'Panel A of Table 14.4 Logistic regression estimates';
Proc logistic data=panela descending;
Class sitetype;
Model comps = sitetype onsiteho|prepost;
weight count;
run;

Title 'Panel A Saturated Loglinear Model';
	Proc catmod data=panela;
	weight count;
	model comps*sitetype*onsiteho*prepost =_response_;
	loglin 	comps|sitetype|onsiteho|prepost; 
run;


Title 'Panel A Best Loglinear Model sites not pooled';
	Proc catmod data=panela;
	weight count;
	model comps*sitetype*onsiteho*prepost =_response_;
	loglin 	comps|sitetype|onsiteho prepost|sitetype; 
run;

Title 'Panel A Best Loglinear Model sites pooled';
	Proc catmod data=panela;
	weight count;
	model comps*onsiteho*prepost =_response_;
	loglin 	comps|onsiteho prepost|onsiteho; 



Data panelb; set q.chap14tab4; 
if conftype =1;

	/*Estimates for Panel b of Table 14.4*/

Title 'Panel b of Table 14.4 Logistic regression estimates';
Proc logistic data=panelb descending;
Class sitetype;
Model comps = sitetype onsiteho|prepost;
weight count;
run;

Title 'Panel b Saturated Loglinear Model';
	Proc catmod data=panelb;
	weight count;
	model comps*sitetype*onsiteho*prepost =_response_;
	loglin 	comps|sitetype|onsiteho|prepost; 
run;


Title 'Panel b Best Loglinear Model sites not pooled';
	Proc catmod data=panelb;
	weight count;
	model comps*sitetype*onsiteho*prepost =_response_;
	loglin 	comps|sitetype|onsiteho prepost|sitetype; 
run;

Title 'Panel b Best Loglinear Model sites pooled';
	Proc catmod data=panelb;
	weight count;
	model comps*onsiteho*prepost =_response_;
	loglin 	onsiteho prepost comps; 
run;





Data panelc; set q.chap14tab4; 
if conftype =2;

/*Estimates for Panel c (surgical or obstetrical confinements) of Table 14.4*/

Title 'Panel c of Table 14.4 Logistic regression estimates';
Proc logistic data=panelc descending;
Class sitetype;
Model comps = sitetype onsiteho|prepost;
weight count;
run;


Title 'Panel c Saturated Loglinear Model';
	Proc catmod data=panelc;
	weight count;
	model comps*sitetype*onsiteho*prepost =_response_;
	loglin 	comps|sitetype|onsiteho|prepost; 
run;


Title 'Panel c Best Loglinear Model sites not pooled';
	Proc catmod data=panelc;
	weight count;
	model comps*sitetype*onsiteho*prepost =_response_;
	loglin 	comps|sitetype|onsiteho sitetype|prepost; 
run;

Title 'Panel c Best Loglinear Model sites pooled';
	Proc catmod data=panelc;
	weight count;
	model comps*onsiteho*prepost =_response_;
	loglin 	onsiteho|prepost comps; 
	run;

	/*The SAS Code for Table 14.4 is now complete, it produces the same results
	as the SPSS Code for these data*/
	/*The syntax in this file is copyright by Robert B. Smith,  2011.*/ 

